/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.interfaces;

import fr.iglee42.evolvedmekanism.recipes.ChemixerRecipe;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemixerCachedRecipe
extends CachedRecipe<ChemixerRecipe> {
    private final IOutputHandler<@NotNull ItemStack> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    private final IInputHandler<@NotNull GasStack> gasInputHandler;
    private ItemStack recipeItem = ItemStack.f_41583_;
    private ItemStack recipeExtra = ItemStack.f_41583_;
    private GasStack recipeGas = GasStack.EMPTY;
    @Nullable
    private ItemStack output;

    public ChemixerCachedRecipe(ChemixerRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, IInputHandler<@NotNull ItemStack> extraInputHandler, IInputHandler<@NotNull GasStack> gasInputHandler, IOutputHandler<@NotNull ItemStack> outputHandler) {
        super((MekanismRecipe)recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.extraInputHandler = Objects.requireNonNull(extraInputHandler, "Extra input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((ChemixerRecipe)this.recipe).getInputMain());
            if (this.recipeItem.m_41619_()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeExtra = (ItemStack)this.extraInputHandler.getRecipeInput((InputIngredient)((ChemixerRecipe)this.recipe).getInputExtra());
                if (this.recipeExtra.m_41619_()) {
                    tracker.mismatchedRecipe();
                } else {
                    this.recipeGas = (GasStack)this.gasInputHandler.getRecipeInput((InputIngredient)((ChemixerRecipe)this.recipe).getInputGas());
                    if (this.recipeGas.isEmpty()) {
                        tracker.mismatchedRecipe();
                    } else {
                        this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                        if (tracker.shouldContinueChecking()) {
                            this.extraInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeExtra);
                            if (tracker.shouldContinueChecking()) {
                                this.gasInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeGas);
                                if (tracker.shouldContinueChecking()) {
                                    this.output = ((ChemixerRecipe)this.recipe).getOutput(this.recipeItem, this.recipeExtra, this.recipeGas);
                                    this.outputHandler.calculateOperationsCanSupport(tracker, (Object)this.output);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        ItemStack item = (ItemStack)this.itemInputHandler.getInput();
        if (item.m_41619_()) {
            return false;
        }
        GasStack gas = (GasStack)this.gasInputHandler.getInput();
        if (gas.isEmpty()) {
            return false;
        }
        ItemStack extra = (ItemStack)this.extraInputHandler.getInput();
        return !extra.m_41619_() && ((ChemixerRecipe)this.recipe).test(item, extra, gas);
    }

    protected void finishProcessing(int operations) {
        if (!(this.output == null || this.recipeItem.m_41619_() || this.recipeExtra.m_41619_() || this.recipeGas.isEmpty())) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            this.extraInputHandler.use((Object)this.recipeExtra, operations);
            this.gasInputHandler.use((Object)this.recipeGas, operations);
            this.outputHandler.handleOutput((Object)this.output, operations);
        }
    }
}

